
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.reflect.Method;
import javax.swing.*;

public class ObjectBrowser extends JFrame {
    JMenuBar fileMenuBar = new JMenuBar();
    JMenuItem fileItem = new JMenuItem("File");
    JLabel classNameLabel = new JLabel("Class:", JLabel.LEFT);
    JLabel methodCountLabel = new JLabel("Number of methods:  ", JLabel.LEFT);
    JLabel methodNameLabel = new JLabel("Method name:  ", JLabel.LEFT);
    JLabel parameterCountLabel = new JLabel("Number of parameters:  ", JLabel.LEFT);
    JLabel returnTypeLabel = new JLabel("", JLabel.LEFT);
    JLabel valueReturnedLabel = new JLabel("", JLabel.LEFT);
    JButton nextButton = new JButton("Next");
    int numMethods = 0;
    int methodIndex = 0;
    JTextField methodNameField = new JTextField();
    String filename = "";
    Object objectBeingBrowsed = null;
    public ObjectBrowser() {
        setBounds(0,0,500,200);
        initComponents();
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
    }
    void initComponents() {
        fileMenuBar.add(fileItem);
        fileItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object oldObject = objectBeingBrowsed;
                FileDialog fd = new FileDialog(ObjectBrowser.this,"Load object");
                fd.setVisible(true);
                if (fd.getDirectory() != null && fd.getFile() != null) {
                    filename = fd.getDirectory() + fd.getFile();
                    setTitle(filename);
                    try {
                        ObjectInputStream binaryIn =
                                new ObjectInputStream(
                                new BufferedInputStream(
                                new FileInputStream(filename)));
                        objectBeingBrowsed = binaryIn.readObject();
                        Class classOfObject = objectBeingBrowsed.getClass();
                        numMethods = classOfObject.getMethods().length;
                        repaint();
                    } catch(Exception exc) {
                        JOptionPane.showMessageDialog(ObjectBrowser.this,
                            "Could not open '"+filename+"'");
                        objectBeingBrowsed = oldObject;
                    }
                }
            }
        });
        setJMenuBar(fileMenuBar);
        Container cp = getContentPane();
        cp.setLayout(new BoxLayout(cp, BoxLayout.Y_AXIS));
        cp.add(classNameLabel);
        cp.add(methodCountLabel);
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, BoxLayout.X_AXIS));
        pane.add(methodNameLabel);
        pane.add(methodNameField);
        cp.add(pane);
        pane.setSize(getBounds().width,20);
        pane.setMaximumSize(new Dimension(getBounds().width,20));
        nextButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                methodIndex = (methodIndex + 1) % numMethods;
                repaint();
            }
        });
        pane.add(nextButton);
        cp.add(parameterCountLabel);
        cp.add(returnTypeLabel);
        cp.add(valueReturnedLabel);
    }
    public void paint(Graphics g) {
        super.paint(g);
        if (objectBeingBrowsed != null) {
            classNameLabel.setText("Class:  " + 
                                   objectBeingBrowsed.getClass().getName());
            Method [] method = objectBeingBrowsed.getClass().getMethods();
            methodCountLabel.setText("Number of methods:  " + method.length);
            methodNameLabel.setText("Method " + (methodIndex+1) + " name:  ");
            methodNameField.setText(method[methodIndex].getName());
            int numParms = method[methodIndex].getParameterTypes().length;
            parameterCountLabel.setText("Number of parameters:  " + numParms);
            Class returnType = method[methodIndex].getReturnType();
            returnTypeLabel.setText("Return type:  " + returnType.getName());
            valueReturnedLabel.setText("");
            if (numParms == 0) {
                try {
                    Object rv =
                        method[methodIndex].invoke(objectBeingBrowsed, 
                        new Object[0]);
                    valueReturnedLabel.setText(
                            "Value returned:  " + rv.toString());
                }
                catch(Exception e) {
                    valueReturnedLabel.setText(
                            "Could not ascertain return value");
                }
            }
        }
    }
    public static void main(String args[]) {
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ObjectBrowser().setVisible(true);
            }
        });
    }
}